/*
 *  MINI SPI CAN CONTROL
 */
#include "WConstants.h"
#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include "pins_arduino.h"
#include <inttypes.h>
#include "global.h"
#include "mcp2515.h"
#include "defaults.h"
#include "mini_spi_can.h"

/* C++ wrapper */
CanbusClass::CanbusClass() 
{ 
}

//char CanbusClass::message_rx(unsigned char *buffer) 
//{
//	tCAN message;
//	
//	if (mcp2515_check_message()) 
//	{				
//		if (mcp2515_get_message(&message)) 
//		{			
//		  buffer[0] = message.data[0];
//		  buffer[1] = message.data[1];
//		  buffer[2] = message.data[2];
//		  buffer[3] = message.data[3];
//		  buffer[4] = message.data[4];
//		  buffer[5] = message.data[5];
//		  buffer[6] = message.data[6];
//		  buffer[7] = message.data[7];																																			
//		}		
//	}
//}

//char CanbusClass::message_tx(void) 
//{
//	tCAN message;
//	
//	message.id = 0x7DF;
//	message.header.rtr = 0;
//	message.header.length = 8;
//	message.data[0] = 0x02;
//	message.data[1] = 0x01;
//	message.data[2] = 0x05;
//	message.data[3] = 0x00;
//	message.data[4] = 0x00;
//	message.data[5] = 0x00;
//	message.data[6] = 0x00;
//	message.data[7] = 0x00;						
//		
//	if (mcp2515_send_message(&message)) 
//	{	
//	  return 1;
//	}
//	else 
//	{
//	  return 0;
//	} 
//}

char CanbusClass::ecu_req(unsigned char pid,  char *buffer) 
{
	tCAN message;
	float engine_data;
	int timeout = 0;
	char message_ok = 0;
	
	message.id = PID_REQUEST;
	message.header.rtr = 0;
	message.header.length = 8;
	message.data[0] = 0x02;
	message.data[1] = 0x01;
	message.data[2] = pid;
	message.data[3] = 0x00;
	message.data[4] = 0x00;
	message.data[5] = 0x00;
	message.data[6] = 0x00;
	message.data[7] = 0x00;						
	
	mcp2515_send_message(&message);
	
	while(timeout < 4000)
	{
		timeout++;
		if (mcp2515_check_message()) 
		{
			if (mcp2515_get_message(&message)) 
			{
				if((message.id == PID_REPLY) && (message.data[2] == pid))	// Check message is the reply and its the right PID
				{
				    /* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
					switch(message.data[2])
					{   
					    //   ((A*256)+B)/4    [RPM]
						case ENGINE_RPM:  			engine_data =  ((message.data[3]*256) + message.data[4])/4;
													sprintf(buffer,"%d rpm ",(int) engine_data);
													break;
											
						// 	A-40			  [degree C]	
						case ENGINE_COOLANT_TEMP: 	engine_data =  message.data[3] - 40;
													sprintf(buffer,"%d degC",(int) engine_data);							
													break;
													
						// A				  [km]	
						case VEHICLE_SPEED: 		engine_data =  message.data[3];
													sprintf(buffer,"%d km ",(int) engine_data);							
													break;
						// Throttle Position	
						case THROTTLE:				engine_data = (message.data[3]*100)/255;
													sprintf(buffer,"%d %% ",(int) engine_data);
													break;
							
					}
					message_ok = 1;
				}
			}
		}
		if(message_ok == 1) return 1;
	}
	
 	return 0;
}

char CanbusClass::init(unsigned char speed) 
{
  return mcp2515_init(speed);
}

CanbusClass mini_spi_can;
